/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.util;

import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;
import org.bukkit.metadata.LazyMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class TimeoutMetadata
extends LazyMetadataValue {
    private long expiry;
    private static Plugin instance;

    public TimeoutMetadata(long timeout) {
        super(instance);
        this.expiry = System.currentTimeMillis() + timeout;
    }

    public TimeoutMetadata(long units, TimeUnit unit) {
        super(instance);
        this.expiry = System.currentTimeMillis() + unit.toMillis(units);
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiry;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public synchronized void invalidate() {
        this.expiry = System.currentTimeMillis();
    }

    public Object value() {
        return this.expiry;
    }

    public static boolean isExpired(Player player, String meta) {
        for (MetadataValue value : player.getMetadata(meta)) {
            if (!(value instanceof TimeoutMetadata)) continue;
            return ((TimeoutMetadata)value).isExpired();
        }
        return true;
    }
}

